/**
 * Script para el Vicerrectorado de Investigacin
 * Manejo de tabs y funcionalidad interactiva
 */

document.addEventListener('DOMContentLoaded', function() {

    // ===================================
    // MANEJO DE TABS
    // ===================================
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const tabId = this.getAttribute('data-tab');

            // Remover clase active de todos los botones y contenidos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));

            // Agregar clase active al botn clickeado
            this.classList.add('active');

            // Mostrar el contenido correspondiente
            const activeContent = document.getElementById(tabId);
            if (activeContent) {
                activeContent.classList.add('active');
            }

            // Scroll suave hacia arriba del contenido
            window.scrollTo({
                top: document.querySelector('.vicerrectorado-main').offsetTop - 100,
                behavior: 'smooth'
            });
        });
    });

    // ===================================
    // ANIMACIONES DE ENTRADA
    // ===================================
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observar las tarjetas informativas
    const infoCards = document.querySelectorAll('.info-card');
    infoCards.forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(card);
    });

    // ===================================
    // NAVEGACIN CON TECLADO
    // ===================================
    tabButtons.forEach((button, index) => {
        button.addEventListener('keydown', function(e) {
            let targetButton;

            if (e.key === 'ArrowDown') {
                e.preventDefault();
                targetButton = tabButtons[index + 1] || tabButtons[0];
            } else if (e.key === 'ArrowUp') {
                e.preventDefault();
                targetButton = tabButtons[index - 1] || tabButtons[tabButtons.length - 1];
            }

            if (targetButton) {
                targetButton.focus();
                targetButton.click();
            }
        });
    });

    // ===================================
    // ACTUALIZAR ARIA ATTRIBUTES
    // ===================================
    function updateAriaAttributes() {
        tabButtons.forEach(button => {
            const isActive = button.classList.contains('active');
            button.setAttribute('aria-selected', isActive);

            const tabId = button.getAttribute('data-tab');
            const tabPanel = document.getElementById(tabId);
            if (tabPanel) {
                tabPanel.setAttribute('aria-hidden', !isActive);
            }
        });
    }

    // Actualizar atributos ARIA al cambiar de tab
    tabButtons.forEach(button => {
        button.addEventListener('click', updateAriaAttributes);
    });

    // Inicializar atributos ARIA
    updateAriaAttributes();

    // ===================================
    // EFECTO HOVER EN TARJETAS
    // ===================================
    infoCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transition = 'all 0.3s ease';
        });
    });

    console.log('Script del Vicerrectorado de Investigacin cargado correctamente');
});
